from .mt5 import *
import datetime
import pandas as pd
import MetaTrader5 as mt5
import ta


def rsi(symbol , tf , candle_type = 'ca'):
    if candle_type == 'ca':
        ohlc = candle(symbol, tf)
    else:
        ohlc = heikin_ashi(symbol, tf)
    candles = pd.DataFrame(ohlc[:])
    candles['rsi'] = ta.momentum.RSIIndicator(candles['close'], window=14).rsi()
    rsi= candles['rsi'].tolist()
    return rsi


def sma_rsi(symbol, tf, rsi_period=14, sma_period=14 , candle_type='ca'):
    
    if candle_type == 'ca':
        ohlc = candle(symbol, tf)
    else:
        ohlc = heikin_ashi(symbol, tf)
    candles = pd.DataFrame(ohlc[:], columns=['open', 'high', 'low', 'close'])

    candles['rsi'] = ta.momentum.RSIIndicator(candles['close'], window=rsi_period).rsi()
    
    candles['sma_rsi'] = ta.trend.SMAIndicator(candles['rsi'], window=sma_period).sma_indicator()
    
    sma_rsi_list = candles['sma_rsi'].tolist()
    
    return sma_rsi_list


def ema(symbol, tf , window , candle_type='ca'):
    if candle_type == 'ca':
        ohlc = candle(symbol, tf)
    else:
        ohlc = heikin_ashi(symbol, tf)

    prices = pd.DataFrame(ohlc[:])
    prices['ema'] = prices['close'].ewm(span = window).mean()
    ema = prices['ema'].values.tolist()
    return (ema)


def sma(symbol, tf, window, candle_type='ca'):
    
    if candle_type == 'ca':
        ohlc = candle(symbol, tf)
    else:
        ohlc = heikin_ashi(symbol, tf)

    prices = pd.DataFrame(ohlc[:])
    
    prices['sma'] = ta.trend.SMAIndicator(prices['close'], window=window).sma_indicator()
   
    ma_values = prices['sma'].values.tolist()
    return ma_values
    

def wma(symbol, tf, window, candle_type='ca'):

    if candle_type == 'ca':
        ohlc = candle(symbol, tf)
    else:
        ohlc = heikin_ashi(symbol, tf)

    prices = pd.DataFrame(ohlc[:])
    
   
    prices['wma'] = ta.trend.WMAIndicator(prices['close'], window=window).wma()
   
    ma_values = prices['wma'].values.tolist()
    return ma_values
  

def cross_signal(series1, series2):
    if series1[-1] > series2[-1] and series1[-2] > series2[-2] and series1[-3] <= series2[-3]:
        return 'buy'
    elif series1[-1] < series2[-1] and series1[-2] < series2[-2] and series1[-3] >= series2[-3]:
        return 'sell'
    else:
        return 'hold'

